# Pattern library
This library parses the patterns of the theme and adds them to the theme. All
components are defined in the theme under the folder `/patterns/{collection}`.
Here, `collection` is a collection for the components, for example: atoms or
molecules. The module registers a pattern using a YAML file. The file must exist
inside his own directory and the directory must exists in a collection. Each
pattern can define its own Twig file and styling, this is defined in the theme
too.

**Example of a pattern recognized by library:**
```
patterns/
    molecules/
        button/
            button.yml
```

## Format of a YAML file
A YAML file of a pattern consists of 4 possible keys:
- `label`: Label that is displayed on the pattern page (Required)
- `description`: Small description that is displayed on the pattern page
  (Optional)
- `show_meta`: Flag to indicate if the meta data should be displayed on the
  pattern page (Default TRUE)
- `template`: A specific template to use for the pattern (Optional)
- `scheme`: Scheme that is displayed on the pattern page (Optional)
- `data`: Data that is displayed on the pattern page (Optional)

**Scheme**
The scheme is used to define the pattern variables and code implementation to
display in de pattern library. Each entry can contain the following information:
label, type, value, required and options. These variables can be overwritten in
the theme.

**Data**
This variable makes it possible to display different implementations of the
pattern. The `data` variable is an array, in which each array contains a
variants variable. Variants can also be grouped, this requires a `variants` key.
The example below shows two groups. Each group contains one or more variants.

**Example YAML file for an icon:**
```yaml
label: Icon
description: 'A smart description'
scheme:
  name:
    label: 'Name'
    type: text
    value: 'chevron'
    required: true
  attributes:
    label: 'Attributes'
    type: object
  size:
    label: 'Size'
    type: string
    options:
      - small
      - large
  direction:
    label: 'Direction'
    type: string
    options:
      - right
      - left
  tag:
    label: 'Tag'
    type: string
data:
  -
    label: 'Icon'
    variants:
      -
        label: 'Icon'
        name: 'chevron'
        attributes: ~
        size: ~
        direction: ~
        tag: 'icon'
  -
    label: 'Directions'
    variants:
      -
        label: 'Chevron right'
        name: 'chevron'
        attributes: ~
        direction: 'right'
        size: 'large'
        tag: 'icon'
      -
        label: 'Chevron left'
        name: 'chevron'
        attributes: ~
        direction: 'left'
        size: 'large'
        tag: 'icon'
```
